//Caption: Program to generate and plot different basic sequences
clear all;
clc;
close;
//Generation of Unit Impulse signal
L = 4;  //Upperlimit
n = -L:L;
x = [zeros(1,L),1,zeros(1,L)];

b = gca();
b.y_location = "middle";
plot2d3('gnn',n,x) 
a=gce();
a.children(1).thickness =4;
xtitle('Graphical Representation of Unit Sample Sequence','n','x[n]');
//Generation of Unit Step Signal
L = 10;  //Upperlimit
t = -L:L;
x = [zeros(1,L),ones(1,L+1)];
figure(1)
subplot(2,1,1)
a=gca();
a.thickness =2;
a.y_location = "middle";
plot2d2(t,x) 
xtitle('Graphical Representation of Unit Step Signal','t','x(t)');
//Generation of Unit Step Sequence
L = 4;  //Upperlimit
n = -L:L;
x = [zeros(1,L),ones(1,L+1)];
subplot(2,1,2)
a=gca();
a.thickness = 2;
a.y_location = "middle";
plot2d3('gnn',n,x) 
xtitle('Graphical Representation of Unit Step Sequence','n','x[n]');
//Generation of Ramp Sequence
L = 4;  //Upperlimit
n = -L:L;
x = [zeros(1,L),0:L];  
figure(2)
subplot(2,1,1)
b = gca();
b.y_location = 'middle';
plot2d3('gnn',n,x) 
a=gce();
a.children(1).thickness =2;
xtitle('Graphical Representation of Discrete Unit Ramp Sequence','n','x[n]');
//Generation of Ramp Signal
L = 4;  //Upperlimit
t = -L:L;
x = [zeros(1,L),0:L];
subplot(2,1,2)  
b = gca();
b.y_location = 'middle';
plot2d(n,x) 
a=gce();
a.children(1).thickness =2;
xtitle('Graphical Representation of Discrete Unit Ramp Sequence','t','x(t)');
//Generation of Exponentially Increasing signal
a =1.5; 
n = 0:10;  
x = (a)^n;
figure(3)
subplot(2,1,1)
a=gca();
a.thickness = 2;
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',n,x) 
xtitle('Graphical Representation of Exponential Increasing Signal','n','x[n]');
//Generation of Exponentailly Decreasing Signal
a =0.5; 
n = 0:10;  
x = (a)^n;
subplot(2,1,2)
a=gca();
a.thickness = 2;
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',n,x) 
xtitle('Graphical Representation of Exponential Decreasing Signal','n','x[n]');
